% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_groups}
\alias{find_groups}
\title{Find groups using text-based search}
\usage{
find_groups(
  query,
  topic_id = NULL,
  category_id = NULL,
  max_results = 200,
  handle_multiples = "list",
  extra_graphql = NULL,
  asis = FALSE,
  ...
)
}
\arguments{
\item{query}{Character string to search for groups}

\item{topic_id}{Numeric ID of a topic to filter groups by}

\item{category_id}{Numeric ID of a category to filter groups by}

\item{max_results}{Maximum number of results to return. If set to NULL,
will return all available results (may take a long time).}

\item{handle_multiples}{Character. How to handle multiple matches. One of
"list" or "first", or "error".
If "list", return a list-column with all matches.
If "first", return only the first match.}

\item{extra_graphql}{A graphql object. Extra objects to return}

\item{asis}{Return the raw API response as-is without processing}

\item{...}{other named variables for graphql query. options are:
\itemize{
\item lat: Float
\item lon: Float
\item radius: Float
\item categoryId: ID
\item topicCategoryId: ID
}}
}
\value{
A tibble with group information
}
\description{
Search for groups on Meetup using a text query. This function allows
you to find groups that match your search criteria.
}
\examples{
\dontshow{
vcr::insert_example_cassette("find_groups", package = "meetupr")
meetupr:::mock_if_no_auth()
}
groups <- find_groups("R-Ladies")
groups
\dontshow{
vcr::eject_cassette()
}
}
