% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_meddra.R
\name{join_meddra}
\alias{join_meddra}
\title{Combine together all of the MedDRA terms into a single data.frame}
\usage{
join_meddra(data)
}
\arguments{
\item{data}{MedDRA source data from \code{read_meddra()}}
}
\value{
A data.frame with the "soc_code", "soc_name", "soc_abbrev",
"hlgt_code", "hlgt_name", "hlt_code", "hlt_name", "pt_code", "pt_name",
"pt_soc_code", "llt_code", "llt_name", and "llt_currency"
}
\description{
Combine together all of the MedDRA terms into a single data.frame
}
\examples{
\dontrun{
meddra_raw <- read_meddra("/path/to/meddra/distribution")
meddra_df <- join_meddra(meddra_raw)
}
}
