% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\encoding{UTF-8}
\name{mcp_example}
\alias{mcp_example}
\title{Get example models and data}
\usage{
mcp_example(name, sample = FALSE)
}
\arguments{
\item{name}{Name of the example. One of:
\itemize{
\item \code{"demo"}: Two change points between intercepts and joined/disjoined slopes.
\item \code{"ar"}: One change point in autoregressive residuals.
\item \code{"binomial"}: Binomial with two change points. Much like \code{"demo"} on a logit scale.
\item \code{"intercepts"}: An intercept-only change point.
\item \code{rel_prior}: Relative parameterization and informative priors.
\item \code{"quadratic"}: A change point to a quadratic segment.
\item \code{"trigonometric"}: Trigonometric/seasonal data and model.
\item \code{"varying"}: Varying / hierarchical change points.
\item \code{"variance"}: A change in variance, including a variance slope.
}}

\item{sample}{TRUE (run \code{fit = mcp(model, data, ...)}) or FALSE.}
}
\value{
List with
\itemize{
\item \code{model}: A list of formulas
\item \code{data}: The simulated data
\item \code{simulated}: The parameters used for simulating the data.
\item \code{fit}: an \code{mcpfit} if \code{sample = TRUE},
\item \code{call}: the code to run the above.
}
}
\description{
Get example models and data
}
\examples{
\donttest{
ex = mcp_example("demo")
plot(ex$data)  # Plot data
print(ex$simulated)  # See true parameters used to simulate
print(ex$call)  # See how the data was simulated

# Fit the model. Either...
fit = mcp(ex$model, ex$data)
plot(fit)

ex_with_fit = mcp_example("demo", sample = TRUE)
plot(ex_with_fit$fit)
}
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
