% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{mzip}
\alias{mzip}
\title{Estimating marginalized zero-inflated Poisson model}
\usage{
mzip(formula, data)
}
\arguments{
\item{formula}{an object of class "\code{formula}" (or one that can be coerced to that class): a symbolic description of the model to be fitted. A typical formula has the form \code{response ~ terms} where \code{response} is the count response vector and \code{terms} is a series of terms that predict response. For example, \code{formula = y ~ x1 + x2 + x3}. Do not write intercept in the \code{formula}; intercept will be automatically added in model fitting.}

\item{data}{a data frame containing variables in the model.}
}
\value{
Suffix \code{_zero} corresponds to the parameters associated with the structrual zero rate part of a model. \cr \cr
Suffix \code{_mean} corresponds to the parameters associated with the overall mean, which evaluate the effects of covariates on the overall mean. \cr
}
\description{
Function to estimate a marginalized zero-inflated Poisson model
}
\details{
Function returns an object of class "\code{mle2}" from \pkg{bbmle} R package. Apply \code{summary} function to the resulting object from the function to obtain more estimation information.
}
\examples{
head(dat.pfi)

#Fit a marginalized zero-inflated Poisson model
res = mzip(formula = y ~ m0 + int_PF + year_new + race_new, data = dat.pfi)

#Obtain estimation results
bbmle::summary(res)
}
\references{
Long, D. L., Preisser, J. S., Herring, A. H., & Golin, C. E. (2014). A marginalized zero‐inflated Poisson regression model with overall exposure effects. Statistics in Medicine, 33(29), 5151-5165.
}
