% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esr.R
\name{esr.mcmcr}
\alias{esr.mcmcr}
\title{Effective Sampling Rate}
\usage{
\method{esr}{mcmcr}(x, by = "all", as_df = FALSE, na_rm = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{by}{A string indicating whether to determine by
"term", "parameter" or "all".}

\item{as_df}{A flag indicating whether to return the results as a
data frame versus a named list.}

\item{na_rm}{A flag specifying whether to ignore missing values.}

\item{...}{Other arguments passed to methods.}
}
\value{
A number between 0 and 1 indicating the esr value.
}
\description{
Calculates the effective sampling rate (\code{esr}).
}
\details{
By default
\deqn{\frac{1}{1 + 2 \sum_{k = 1}^\infty\rho_k(\theta)}}
from Brooks et al. (2011) where the infinite sum is truncated at
lag \eqn{k} when \eqn{\rho_{k+1}(\theta) < 0}.
}
\examples{
esr(mcmcr_example)
}
\references{
Brooks, S., Gelman, A., Jones, G.L., and Meng, X.-L. (Editors). 2011.
Handbook for Markov Chain Monte Carlo. Taylor & Francis, Boca Raton.
}
\seealso{
Other convergence: 
\code{\link[universals]{converged}()},
\code{\link[universals]{converged_pars}()},
\code{\link[universals]{converged_terms}()},
\code{\link[universals]{esr_pars}()},
\code{\link[universals]{esr_terms}()},
\code{\link[universals]{rhat}()},
\code{\link[universals]{rhat_pars}()},
\code{\link[universals]{rhat_terms}()}
}
