% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probitnorm.R
\name{mcmap_probitnorm}
\alias{mcmap_probitnorm}
\title{Mapper function for probit-normal distribution}
\usage{
mcmap_probitnorm(
  target = c(m = 0.25, c = 0.75),
  method = "",
  integrate_controls = list(),
  optim_controls = list()
)
}
\arguments{
\item{target}{A vector of size 2. The first element is mean and the second element is c-statistic.}

\item{method}{Fir compatibilty with other functions. Use "" for now (alternative optimization methods might be implemented in the future)}

\item{integrate_controls}{(optional): parameters to be passed to integrate()}

\item{optim_controls}{(optional): parameters to be passed to optim()}
}
\value{
A vector of size two that contains the distribution parameters
}
\description{
Maps a pair of mean and c-statistic value to the parameters of a pobit-normal distribution
}
\examples{
mcmap_probitnorm(c(0.1, 0.75))
}
