% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.R
\name{write_assoc}
\alias{write_assoc}
\title{Write association scores to file}
\usage{
write_assoc(x, file = "", sep = "\\t")
}
\arguments{
\item{x}{An object of class \code{\link{assoc_scores}}.}

\item{file}{Name of the output file.}

\item{sep}{Field separator for the output file.}
}
\value{
Invisibly, \code{x}.
}
\description{
This function writes an object of class \code{\link{assoc_scores}} to a file.
}
\examples{
txt1 <- "we're just two lost souls swimming in a fish bowl,
year after year, running over the same old ground,
what have we found? the same old fears.
wish you were here."
flist1 <- freqlist(txt1, as_text = TRUE)
txt2 <- "picture yourself in a boat on a river
with tangerine dreams and marmelade skies
somebody calls you, you answer quite slowly
a girl with kaleidoscope eyes"
flist2 <- freqlist(txt2, as_text = TRUE)
(scores <- assoc_scores(flist1, flist2, min_freq = 0))
\dontshow{.old_wd <- setwd(tempdir())}
write_assoc(scores, "example_scores.tab")
(scores2 <- read_assoc("example_scores.tab"))
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=read_assoc]{read_assoc()}}

Other writing functions: 
\code{\link{write_conc}()},
\code{\link{write_fnames}()},
\code{\link{write_freqlist}()},
\code{\link{write_tokens}()},
\code{\link{write_txt}()},
\code{\link{write_types}()}
}
\concept{writing functions}
