% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/freqlist.R
\name{ranks}
\alias{ranks}
\alias{ranks.freqlist}
\title{Retrieve the current ranks for frequency counts.}
\usage{
ranks(x, ...)

\method{ranks}{freqlist}(x, with_names = FALSE, ...)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{...}{Additional arguments.}

\item{with_names}{Logical. Whether or not the items in the output should
be given names. If \code{TRUE}, then the names
of the types in the frequency list are used as names.}
}
\value{
Numeric vector representing the current ranks, with as its names
the types to which the ranks apply.
}
\description{
\code{ranks} retrieves from the ranks of its items in an object.
These ranks are integer values running from one up to the number of items
in \code{x}. Each items receives a unique rank.
Items are first ranked by frequency in descending order. Items with
identical frequency are further ranked by alphabetic order.
}
\details{
The mclm method \code{\link[=ranks]{ranks()}} is not
to be confused with \code{\link[base:rank]{base::rank()}}. There are two
important differences.

First,\code{\link[base:rank]{base::rank()}} always ranks items from low values to
high values and \code{\link[=ranks]{ranks()}} ranks from high
frequency items to low frequency items.

Second, \code{\link[base:rank]{base::rank()}} allows the user to choose among
a number of different ways to handle ties.
In contrast, \code{\link[=ranks]{ranks()}} always handles ties
in the same way. More specifically, items with identical frequencies
are always ranked in alphabetical order.

In other words, \code{\link[base:rank]{base::rank()}} is a flexible tool that
supports a number of different ranking methods that are commonly used in
statistics. In contrast, \code{\link[=ranks]{ranks()}} is a
rigid tool that supports only one type of ranking, which is a type of
ranking that is atypical from a statistics point of view, but is commonly
used in linguistic frequency lists. Also, it is designed to be unaffected
by the order of the items in the frequency list.
}
\examples{
(flist <- freqlist("The man and the mouse.", as_text = TRUE))

orig_ranks(flist)
ranks(flist)
ranks(flist, with_names = TRUE)

(flist2 <- keep_types(flist, c("man", "and")))

orig_ranks(flist2)
ranks(flist2)
}
\seealso{
Other getters and setters: 
\code{\link{n_tokens}()},
\code{\link{n_types}()},
\code{\link{orig_ranks}()},
\code{\link{tot_n_tokens}()},
\code{\link{type_names}()}
}
\concept{getters and setters}
