% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize.R
\name{merge_tokens}
\alias{merge_tokens}
\alias{tokens_merge}
\alias{tokens_merge_all}
\title{Merge \code{tokens} objects}
\usage{
tokens_merge(x, y)

tokens_merge_all(...)
}
\arguments{
\item{x, y}{An object of class \code{\link{tokens}}}

\item{...}{Objects of class \code{\link{tokens}} or a list with objects of class \code{\link{tokens}}.}
}
\value{
An object of class \code{\link{tokens}}.
}
\description{
\code{tokens_merge()} merges two \code{\link{tokens}} objects \code{x} and \code{y} into a larger
\code{\link{tokens}} object. \code{tokens_merge_all()} merge all the arguments into one
\code{\link{tokens}} object. The result is a concatenation of the tokens, in which the
order of the items in the input is preserved.
}
\examples{
(tks1 <- tokenize(c("This is a first sentence.")))
(tks2 <- tokenize(c("It is followed by a second one.")))
(tks3 <- tokenize(c("Then a third one follows.")))

tokens_merge(tks1, tks2)
tokens_merge_all(tks1, tks2, tks3)
tokens_merge_all(list(tks1, tks2, tks3))
}
