% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conc.R
\name{as_conc}
\alias{as_conc}
\title{Coerce data frame to a concordance object}
\usage{
as_conc(x, left = NA, match = NA, right = NA, keep_original = FALSE, ...)
}
\arguments{
\item{x}{A data frame.}

\item{left}{The name of the column in \code{x} that contains the left co-text
of the concordance. Is \code{is.na(left)}, then this column is assumed
to have the name \code{"left"}.}

\item{match}{The name of the column in \code{x} that contains the match
of the concordance. Is \code{is.na(match)}, then this column is assumed
to have the name \code{"match"}.}

\item{right}{The name of the column in \code{x} that contains the right co-text
of the concordance. Is \code{is.na(right)}, then this column is assumed
to have the name \code{"right"}.}

\item{keep_original}{Logical. If the values of
\code{left}, \code{match} or \code{right} are not \code{NA}, should
the original names of those columns be kept in the \code{\link{conc}} object.}

\item{...}{Additional arguments.}
}
\value{
Object of class \code{conc}, a kind of data frame with as its rows
the matches and with the following columns:
\itemize{
\item \code{glob_id}: Number indicating the position of the match in the
overall list of matches.
\item \code{id}: Number indicating the position of the match in the list of matches
for one specific query.
\item \code{source}: Either the filename of the file in which the match was found
(in case of the setting \code{as_text = FALSE}), or the string '-'
(in case of the setting \code{as_text = TRUE}).
\item \code{left}: The left-hand side co-text of each match.
\item \code{match}: The actual match.
\item \code{right}: The right-hand side co-text of each match.
}

It also has additional attributes and methods such as:
\itemize{
\item base \code{\link[=as_data_frame]{as_data_frame()}} and \code{\link[=print.types]{print()}} methods, as well as
a \code{\link[=print_kwic]{print_kwic()}} function,
\item an \code{\link[=explore]{explore()}} method.
}

An object of class \code{conc} can be merged with another by means of \code{\link[=merge_conc]{merge_conc()}}.
It can be written to file with \code{\link[=write_conc]{write_conc()}} and then
read with \code{\link[=read_conc]{read_conc()}}. It is also possible to import concordances created
by means other than \code{\link[=write_conc]{write_conc()}} with \code{\link[=import_conc]{import_conc()}}.
}
\description{
This function coerces a data frame to an object of the class \code{\link{conc}}.
}
\examples{
(conc_data <- conc('A very small corpus.', '\\\\w+', as_text = TRUE))
df <- as.data.frame(conc_data)
as_conc(df)
}
