% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_lagr_exp.R
\name{cor_lagr_exp}
\alias{cor_lagr_exp}
\title{Calculate Lagrangian correlation of the exponential form}
\usage{
cor_lagr_exp(v1, v2, k = 2, h1, h2, u)
}
\arguments{
\item{v1}{Prevailing wind, u-component.}

\item{v2}{Prevailing wind, v-component.}

\item{k}{Scale parameter of \eqn{\|\boldsymbol v\|}, \eqn{k>0}. Default is 2.}

\item{h1}{Horizontal distance matrix or array.}

\item{h2}{Vertical distance matrix or array, same dimension as \code{h1}.}

\item{u}{Time lag, same dimension as \code{h1}.}
}
\value{
Correlations of the same dimension as \code{h1}.
}
\description{
Calculate Lagrangian correlation of the exponential form
}
\details{
The Lagrangian correlation function of the exponential form with parameters
\eqn{\boldsymbol v = (v_1, v_2)^\top\in\mathbb{R}^2} has the form
\deqn{C(\mathbf{h}, u)=\exp\left(-\dfrac{1}{k\|\boldsymbol v\|}
\left\|\mathbf{h}-u\boldsymbol v\right\|\right),}
where \eqn{\|\cdot\|} is the Euclidean distance,
\eqn{\mathbf{h} = (\mathrm{h}_1, \mathrm{h}_2)^\top\in\mathbb{R}^2},
and \eqn{k > 0} is the scale parameter controlling the magnitude of
asymmetry in correlation.
}
\examples{
h1 <- matrix(c(0, -5, 5, 0), nrow = 2)
h2 <- matrix(c(0, -8, 8, 0), nrow = 2)
u <- matrix(0.1, nrow = 2, ncol = 2)
cor_lagr_exp(v1 = 5, v2 = 10, h1 = h1, h2 = h2, u = u)

h1 <- array(c(0, -10, 10, 0), dim = c(2, 2, 3))
h2 <- array(c(0, -10, 10, 0), dim = c(2, 2, 3))
u <- array(rep(-c(1, 2, 3), each = 4), dim = c(2, 2, 3))
cor_lagr_exp(v1 = 10, v2 = 10, h1 = h1, h2 = h2, u = u)

}
\references{
Diggle, P. J., Tawn, J. A., & Moyeed, R. A. (1998). Model-Based
Geostatistics. Journal of the Royal Statistical Society. Series C (Applied
Statistics), 47(3), 299–350.
}
\seealso{
Other correlation functions: 
\code{\link{cor_cauchy}()},
\code{\link{cor_exp}()},
\code{\link{cor_fs}()},
\code{\link{cor_lagr_askey}()},
\code{\link{cor_lagr_tri}()},
\code{\link{cor_sep}()},
\code{\link{cor_stat}()},
\code{\link{cor_stat_rs}()}
}
\concept{correlation functions}
