% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prob.R
\docType{methods}
\name{plot_prob}
\alias{plot_prob}
\alias{plot_prob,mbsts-method}
\title{Plot Inclusion Probabilities}
\usage{
plot_prob(object, title = NULL, prob.threshold = 0.2, varnames = NULL)

\S4method{plot_prob}{mbsts}(object, title = NULL, prob.threshold = 0.2, varnames = NULL)
}
\arguments{
\item{object}{An object of the mbsts class created by a call to the mbsts_function function.}

\item{title}{NULL or A character vector whose entries are titles for the inclusion probability plots generated for each target series, such as c("Inclusion Probabilities for y1", "Inclusion Probabilities for y2"). If Null, the output is c("y1","y2",...).}

\item{prob.threshold}{A numerical value used as the threshold to only include predictors whose inclusion probabilities are higher than it in the plot. The default value is \eqn{0.2}.}

\item{varnames}{NULL or A character vector whose entries are the variable names for predictors, such as c("x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8"). If Null, the output is c("x11","x12",...,"x21","x22",...).}
}
\description{
Plots of the empirical inclusion probabilities for predictors of each target series, based on a user-defined threshold probability. For example, one predictor is selected \eqn{100} times in \eqn{200} MCMC draws (after discard burn-in draws), the empirical inclusion probability for that predictor is \eqn{0.5}. If the user-defined threshold probability less than or equal to \eqn{0.5}, then this predictor will show in the plot.
}
\references{
\Qiu2018

\Ning2021

\Jammalamadaka2019
}
\author{
Jinwen Qiu \email{qjwsnow_ctw@hotmail.com} Ning Ning \email{patricianing@gmail.com}
}
