
#' @title Plot for Convergence Diagnosis
#' @author Ning Ning \email{patricianing@gmail.com}
#' @description Plot of the parameter draw for MCMC iterations after burn-in.
#' 
#' @docType methods
#' 
#' @param object An object of the mbsts class created by a call to the mbsts_function function.
#' @param index A numerical value indicating which predictor to analyze. The index can be generated by a call to the para.est function
#' @param type NULL or a character vector whose entries are titles for the plots of target series' posterior state components, such as c("Posterior State Components of y1", "Posterior State Components of y2"). The default is c("y1","y2",...).
#' @param col The same setting as that of the plot function in the base package.
#' @param pch The same setting as that of the plot function in the base package.
#' @param lty The same setting as that of the plot function in the base package.
#' @param xlab The same setting as that of the plot function in the base package.
#' @param ylab The same setting as that of the plot function in the base package.
#' @param main The same setting as that of the plot function in the base package.
#' @param cex.axis The same setting as that of the plot function in the base package.
#'
#'@references
#'\Qiu2018
#'
#'\Ning2021
#'
#'\Jammalamadaka2019


#' @export
setGeneric(
  "plot_cvg",
  function (object, index, type="o", col="blue", pch=16, lty=1, xlab="Number of iterations", 
            ylab="Estimation",main="Predictor",cex.axis=1.15)
    standardGeneric("plot_cvg")
)

#' @rdname plot_cvg
setMethod(
  "plot_cvg",
  signature=signature(object="mbsts"),
  definition=function (
    object, index, type="o", col="blue", pch=16, lty=1, xlab="Number of iterations", 
    ylab="Estimation",main="Predictor",cex.axis=1.15
    ) {
    tryCatch(
      plot_cvg.internal(
        object, index, type=type, col=col, pch=pch, lty=lty, 
        xlab=xlab, ylab=ylab, main=main, cex.axis=cex.axis
      )
    )
  }
)


################ plot state component ##############
plot_cvg.internal <-
  function(object, index, type="o", col="blue", pch=16, lty=1, xlab="Number of iterations", 
           ylab="Estimation",main="Predictor",cex.axis=1.15){ 
    
    datatest=object@beta.hat
    i=index
    
    x<-1:length(datatest[i,])
    cvg.plot=plot(x, datatest[i,], type=type, col=col, pch=pch, lty=lty, xlab=xlab, ylab=ylab, main=main, cex.axis=cex.axis)
    
    return (cvg.plot)
    
  } 




