% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{calc_p}
\alias{calc_p}
\title{p-value for Pimentel's tau_b}
\usage{
calc_p(x, y, estimator = "values", p11 = 0, p01 = 0, p10 = 0)
}
\arguments{
\item{x, y}{vectors to be correlated. Must be numeric.}

\item{estimator}{string indicating how the parameters $p_{11}$, $p_{01}$,
$p_{10}$, $p_{00}$ are to be estimated. The default is 'values', which
indicates that they are estimated based on the entries of x and y. If
estimates=='mean', each $p_ji$ is estimated as the mean of all pairs of
column vectors in m1, and of m2 if needed. If estimates=='own', the
$p_ji$'s must be given as arguments.}

\item{p11}{probability that a bivariate observation is of the type (m,n),
where m,n>0}

\item{p01}{probability that a bivariate observation is of the type (0,n),
where n>0}

\item{p10}{probability that a bivariate observation is of the type (n,0),
where n>0}
}
\value{
p-value of correlation.
}
\description{
Computes an estimated p-value for Kendall's Tau_b for zero inflated
continuous data as in Pimentel(2009).
}
\keyword{internal}
