% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assert}
\alias{assert}
\title{Assert if condition is true}
\usage{
assert(cond, msg = "Assertion failed.", A = NULL)
}
\arguments{
\item{cond}{Logical test}

\item{msg}{Error message to be displayed if \code{cond == FALSE}}

\item{A}{values to format \code{msg} if the latter contains C-style
formatting commands.
formatted as parsable}
}
\value{
The error message if \code{cond == FALSE}, nothing otherwise
}
\description{
Throw error if condition false
}
\examples{
minVal <- 7
x <- 26
assert(minVal < x) # should return nothing
maxVal <- 13
\dontrun{
  assert((minVal < x) && (x < maxVal))
  assert(x == "a", "x is \%s", class(x))
}
}
\author{
Waldir Leoncio
}
