% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unwrap.R
\name{unwrap}
\alias{unwrap}
\alias{unwrap_or}
\title{Extract the Value Contained in Enum}
\usage{
unwrap(x, ...)

unwrap_or(x, alt, ...)
}
\arguments{
\item{x}{Enumerated value to unwrap}

\item{...}{objects to be passed to methods.}

\item{alt}{Alternative value to be returned in case of failure}
}
\value{
an object of any class.
}
\description{
Returns the value contained inside of an enum variant. The function strips all relevant attributes from the
object, returning its bare value.
}
\details{
\code{unwrap} is used to extract the inside objects of an \link{Enum}. Unless the Enum was assigned a specific
value, the returned value will be a list with names equal to those in the Enum declaration.

\code{\link{Result}} and \code{\link{Option}} have associated \code{unwrap} methods that automatically
call an error and stop execution if the variant is either \code{Err(e)} or \code{None}, respectively.
\code{unwrap_or} allows the user to specify an alternative value in case of failure on the part of
\code{Result} or \code{Option}.
}
\section{Functions}{
\itemize{
\item \code{unwrap_or}: Extract the inside of Enum. If variant is 'Err' or 'None', the alternative is returned.
}}

\examples{
Color <- Enum(
  "Color",
  Black = c(0,0,0),
  Red   = c(255,0,0),
  Green = c(0, 255, 0),
  Blue  = c(0, 0, 255),
  White = c(255, 255, 255)
)

red_rgb <- unwrap(Color$Red)
blue    <- rev(red_rgb)
blue

new_err <- Err("hello world!")
unwrap_or(new_err, "this is not an error")

}
