% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{is.enum_type}
\alias{is.enum_type}
\title{Check Enum Type}
\usage{
is.enum_type(x, type, ...)
}
\arguments{
\item{x}{object to be tested}

\item{type}{character string denoting type to check.}

\item{...}{objects passed to methods}
}
\value{
\code{TRUE} if \code{x} has enumerated type \code{type}, \code{FALSE} otherwise
}
\description{
Test whether \code{\link{Enum}} is also of class \code{type}.
}
\examples{
HelloEnum <- Enum(
  "HelloEnum",
  Hello,
  World
)

# TRUE
is.enum_type(HelloEnum$Hello, "HelloEnum")

# FALSE
is.enum_type(HelloEnum$Hello, "Hello")
}
