% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unwrap.R
\name{bang}
\alias{bang}
\alias{!.Result}
\alias{!.Option}
\title{Extract Result or Return}
\usage{
\method{!}{Result}(x, ...)

\method{!}{Option}(x, ...)
}
\arguments{
\item{x}{Enumerated value of type \link{Result} or \link{Option} to unwrap}

\item{...}{objects to be passed to methods.}
}
\value{
an object of any class or \code{x} if failure.
}
\description{
Returns the value contained inside of an \link{Result} or \link{Option} Enum or returns if failure.
}
\details{
This is similar to \code{\link{unwrap}} for \link{Result} and \link{Option} objects. However,
an \code{Err} or \code{None} variant does not cause execution to stop. Instead, the parent
function immediately returns the Enum intact. Inspired by the \code{?} operator in Rust.
}
\section{Functions}{
\itemize{
\item \code{!.Result}: Unwrap Result if Ok, otherwise return the Err variant in the parent function.

\item \code{!.Option}: Unwrap Option if Some, otherwise return the None variant in the parent function.
}}

\examples{
is_big <- function(x) {
  if (x > 10) return(Ok(x))
  Err("This is small!")
}

# If 'x' is greater than 10, the value will be printed.
# Otherwise, an error is returned.
print_big <- function(x) {
  print(!is_big(x))
}

}
