% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.R
\name{f}
\alias{f}
\title{Normalized net flux function}
\usage{
f(z, tau, al = 0.1)
}
\arguments{
\item{z}{Sun zenith angle [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, ranges from 0.1 to 0.4)}
}
\value{
Normalized net flux (dimensionless)
}
\description{
Calculates the normalized net solar flux on the Martian surface accounting for multiple
wavelength and multiple scattering in the atmosphere. Based on Pollack's calculations
presented in Appelbaum & Flood (1990). Can use polynomial expression or lookup tables.
}
\section{Environment Variables}{

The function behavior can be configured via environment variables:

\strong{NET_FLUX_FUNCTION_TYPE}: Controls which implementation to use:
\itemize{
  \item \code{"polynomial"} (default) - Analytical polynomial expression with ~0.7\% mean error.
        Maximum error ~7\% at zenith angles 80-85° and tau > 5.
  \item \code{"lookup_v1"} - Lookup table from NASA TM-102299. Albedo fixed at 0.1.
  \item \code{"lookup_v2"} - Lookup table from NASA TM-103623. Supports albedo 0.1 and 0.4.
}

Set with: \code{Sys.setenv(NET_FLUX_FUNCTION_TYPE = "polynomial")}

\strong{NET_FLUX_FUNCTION_SHOW_WARNINGS}: Controls warning display (TRUE/FALSE, default: TRUE).
Warnings are shown when polynomial calculations may have notable error margin (tau > 5 or z >= 80°).

Set with: \code{Sys.setenv(NET_FLUX_FUNCTION_SHOW_WARNINGS = TRUE)}
}

