% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H_i.R
\name{H_i}
\alias{H_i}
\title{Global daily insolation on Mars inclined surface}
\usage{
H_i(
  Ls,
  phi,
  longitude,
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau),
  beta,
  gamma_c
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}

\item{beta}{Surface tilt/slope angle from horizontal [deg]}

\item{gamma_c}{Surface azimuth angle [deg]. Zero facing equator, east negative, west positive (-180 to +180)}
}
\value{
Global daily insolation on inclined surface [Wh/m²-day]
}
\description{
Calculates the total solar energy received over a full Martian day on an inclined surface.
Obtained by integrating global hourly insolation from sunrise to sunset. Based on
Appelbaum, Flood & Norambuena (1994).
}
