% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F06.R
\name{F06}
\alias{F06}
\title{Step Function / Shifted Sphere (F06)}
\usage{
F06(x)
}
\arguments{
\item{x}{Numeric vector of input values.}
}
\value{
Numeric scalar representing the function value.
}
\description{
A shifted version of the Sphere function with the minimum at
\eqn{(-0.5, -0.5, ..., -0.5)}, also known as the Step function.
}
\details{
\strong{Formula:}
\deqn{f(x) = \sum_{i=1}^{n} (x_i + 0.5)^2}{f(x) = sum((x_i + 0.5)^2)}

\strong{Global minimum:} \eqn{f(-0.5, -0.5, ..., -0.5) = 0}

\strong{Characteristics:}
\itemize{
  \item Type: Unimodal
  \item Separable: Yes
  \item Differentiable: Yes
  \item Convex: Yes
  \item Default bounds: \eqn{[-100, 100]^n}
  \item Default dimensions: 50
}

This function tests the algorithm's ability to find optima that are not
located at the origin.
}
\examples{
F06(c(-0.5, -0.5))       # Returns 0 (global minimum)
F06(c(0, 0))             # Returns 0.5
F06(rep(-0.5, 50))       # Returns 0 in 50 dimensions

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters.
}
