% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawFeatures}
\alias{drawFeatures}
\title{Draw (simple) features on a map}
\usage{
drawFeatures(
  map = NULL,
  sf = TRUE,
  record = FALSE,
  viewer = shiny::paneViewer(),
  title = "Draw Features",
  editor = "leafpm",
  editorOptions = list(),
  ...
)
}
\arguments{
\item{map}{a background \code{leaflet} or \code{mapview} map
to be used for editing. If \code{NULL} a blank
mapview canvas will be provided.}

\item{sf}{\code{logical} return simple features.  The default is \code{TRUE}.
If \code{sf = FALSE}, \code{GeoJSON} will be returned.}

\item{record}{\code{logical} to record all edits for future playback.}

\item{viewer}{\code{function} for the viewer.  See Shiny \code{shiny::viewer}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}

\item{title}{\code{string} to customize the title of the UI window.}

\item{editor}{\code{character} currently, only "leafpm" is supported.}

\item{editorOptions}{\code{list} of options suitable for passing to
\code{leafpm::addPmToolbar}.}

\item{...}{additional arguments passed on to \code{\link{editMap}}.}
}
\description{
Draw (simple) features on a map
}
\details{
When setting \code{viewer = browserViewer(browser = getOption("browser"))} and
the systems default browser is Firefox, the browser window will likely not
automatically close when the app is closed (by pressing "done" or "cancel").
To enable automatic closing of tabs/windows in Firefox try the following:
\itemize{
\item{input "about:config " to your firefox address bar and hit enter}
\item{make sure your "dom.allow_scripts_to_close_windows" is true}
}
}
