% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_control}
\alias{add_control}
\alias{add_navigation_control}
\alias{add_scale_control}
\alias{add_fullscreen_control}
\title{Add a standard control to the map}
\usage{
add_control(map, control_name, ..., pos = NULL)

add_navigation_control(map, ..., pos = NULL)

add_scale_control(map, ..., pos = NULL)

add_fullscreen_control(map, pos = NULL)
}
\arguments{
\item{map}{A \link{mapboxer} object.}

\item{control_name}{The (class) name of the control.}

\item{...}{The options of the control.}

\item{pos}{The position of the control. One of \code{top-left}, \code{top-right},
\code{bottom-right} or \code{bottom-left}.}
}
\description{
Add a standard control to the map
}
\examples{
map <- mapboxer() \%>\%
  add_navigation_control(
    pos = "top-left",
    showCompass = FALSE
  ) \%>\%
  add_fullscreen_control() \%>\%
  add_scale_control(
    unit = "nautical"
  )

if (interactive()) map
}
\seealso{
\url{https://docs.mapbox.com/mapbox-gl-js/api/markers/} for available options for the used control.
}
