% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{obs_rows}
\alias{obs_rows}
\alias{obs_rows.data.frame}
\alias{obs_rows.missing}
\alias{obs_rows.mrgmod}
\title{Add observation lines to a dataset}
\usage{
obs_rows(x, ...)

\method{obs_rows}{data.frame}(
  x,
  ID = NULL,
  time = NULL,
  evid = 0L,
  cmt,
  DV = NA_real_,
  mdv = NULL,
  .datehour = NULL,
  ...
)

\method{obs_rows}{missing}(...)

\method{obs_rows}{mrgmod}(x, cmt = NULL, DV = NA_real_, DVmet = NULL, ...)
}
\arguments{
\item{x}{either a data.frame or a 'mrgsolve' model object}

\item{...}{additional columns}

\item{ID}{subject ID (default is 1)}

\item{time}{event time. Default is 0 if no previous events. Mind consistency with \code{.datehour}.}

\item{evid}{event identification (default is 1 for administration, 0 for observation)}

\item{cmt}{compartment (no default, except if \verb{[OBS]} was tagged in the \verb{$CMT} block in model code. See \code{examples}.)}

\item{DV}{dependent value, i.e. observed concentration.}

\item{mdv}{missing dependent value (default is 0 a non-missing concentration value to take into account for parameter estimation, 1 otherwise)}

\item{.datehour}{a object of class POSIXct, a number or a character vector that can be passed to \code{\link[=parse_datehour]{parse_datehour()}}. Using \code{.datehour} will update the value of \code{time} in the dataset, with units in hours. Mind consistency with the \code{time} argument.}

\item{DVmet}{second observation at the same time (e.g. a metabolite, "DVmet") observed jointly with parent drug ("DV"). Works only if \code{x} is a 'mrgsolve' model where two \verb{[OBS]} compartments were defined (see \code{examples})}
}
\value{
a data.frame, or a 'mrgsolve' model with a dataset in the \verb{@args$data} slot (accessible with \code{\link[=get_data]{get_data()}}).
}
\description{
The \code{obs_rows()} function adds an one or several observation lines to a dataset provided as a proper data.frame or within a 'mrgsolve' model. Used in combination with \code{\link[=adm_rows]{adm_rows()}} and \code{\link[=add_covariates]{add_covariates()}}, it helps the creation of datasets in the proper format for simulations with 'mrgsolve' or parameter estimation with 'mapbayr', as explained in \link{data_helpers}.
}
\examples{
# Create a dataset from scratch
obs_rows(time = 12, DV = 0.12, cmt = 2)

# Pipe-friendly addition of observation record to a pre-existing dataset
library(magrittr)
obs_rows(time = 12, DV = 0.12, cmt = 2) \%>\%
  obs_rows(time = c(24, 36, 48), DV = c(0.34, 0.56, 0.78), mdv = c(0, 1, 0), cmt = 2)

# Inform times using the `.datehour` argument:
obs_rows(.datehour = "2020-01-01 11:11", DV = 0.12, cmt = 1) \%>\%
  obs_rows(.datehour = "2020-01-02 22:22", DV = 0.34, cmt = 1) \%>\%
  obs_rows(time = 48, DV = 0.56, cmt = 1)

# Start from a 'mrgsolve' model
library(mrgsolve)
house() \%>\%
  obs_rows(time = 12, DV = 0.12, cmt = 2) \%>\%
  obs_rows(time = c(24, 36, 48), DV = c(0.34, 0.56, 0.78), mdv = c(0, 1, 0), cmt = 2) \%>\%
  mrgsim()

# Default observation compartments
# Set default observation compartments in the code with `[OBS]`
model <- mcode("model", "
$CMT @annotated
DEPOT : Depot
CENTR : Central [OBS]
", compile = FALSE)
obs_cmt(model)

# Thus, no need to manually specify `cmt = 2` anymore.
model \%>\%
  obs_rows(time = 12, DV = 0.12) \%>\%
  obs_rows(time = c(24, 36, 48), DV = c(0.34, 0.56, 0.78), mdv = c(0, 1, 0)) \%>\%
  get_data()

# Automatic lines duplication if parent + metabolite defined in the model
model <- mcode("model", "
$CMT @annotated
DEPOT : Depot
CENTR : Central [OBS]
PERIPH : Periph
METABO : Metabo [OBS]
", compile = FALSE)
obs_cmt(model)

model \%>\%
  obs_rows(time = 12, DV = 0.12, DVmet = 120) \%>\%
  obs_rows(
    time = c(24, 36, 48), DV = c(0.34, 0.56, 0.78),
    mdv = c(0, 1, 0), DVmet = c(340, 560, 780)
  ) \%>\%
  get_data()
}
\seealso{
\link{data_helpers}
}
