/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.regression.tui;

import cc.mallet.pipe.FeatureValueString2FeatureVector;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.Target2Double;
import cc.mallet.pipe.Target2Integer;
import cc.mallet.pipe.ValueString2FeatureVector;
import cc.mallet.pipe.iterator.CsvIterator;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class RegressionImporter {
    static CommandOption.File inputFile = new CommandOption.File(RegressionImporter.class, "input", "FILE", true, null, "The file containing data to be classified, one instance per line", null);
    static CommandOption.File outputFile = new CommandOption.File(RegressionImporter.class, "output", "FILE", true, new File("text.vectors"), "Write the instance list to this file; Using - indicates stdout.", null);
    static CommandOption.String lineRegex = new CommandOption.String(RegressionImporter.class, "line-regex", "REGEX", true, "^\\s*(\\S*)[\\s,]*(.*)$", "Regular expression containing regex-groups for response, variables and name fields.\nDefault is response followed by explanatory variables, with no instance name.", null);
    static CommandOption.Integer labelOption = new CommandOption.Integer(RegressionImporter.class, "response", "INTEGER", true, 1, "The index of the group containing the response variables.\n   Use 0 to indicate that the label field is not used.", null);
    static CommandOption.Integer nameOption = new CommandOption.Integer(RegressionImporter.class, "name", "INTEGER", true, 0, "The index of the group containing the instance name.\n   Use 0 to indicate that the name field is not used.", null);
    static CommandOption.Integer dataOption = new CommandOption.Integer(RegressionImporter.class, "data", "INTEGER", true, 2, "The index of the group containing the explanatory variables.", null);
    static CommandOption.Boolean integerResponse = new CommandOption.Boolean(RegressionImporter.class, "integer-response", "[TRUE|FALSE]", false, false, "If true, interpret the response variable as an integer rather\n   than a double precision real number. Use for Poisson regression.", null);
    static CommandOption.Boolean useFeatureValuePairs = new CommandOption.Boolean(RegressionImporter.class, "use-feature-value-pairs", "[TRUE|FALSE]", false, false, "If true, process the data field as a series of \"feature=value\" pairs rather\n   than an ordered sequence of variables. Useful when most variables are 0.", null);
    static CommandOption.SpacedStrings fieldNames = new CommandOption.SpacedStrings(RegressionImporter.class, "field-names", "[A B C ...]", false, null, "Use this option to specify names for the explanatory variables\n   when you are not using feature name/value pairs", null);

    public static void main(String[] args) throws IOException {
        CommandOption.setSummary(RegressionImporter.class, "A tool for importing data suitable for linear and Poisson regression");
        CommandOption.process(RegressionImporter.class, args);
        ArrayList<Pipe> pipeList = new ArrayList<Pipe>();
        if (RegressionImporter.useFeatureValuePairs.value) {
            pipeList.add(new FeatureValueString2FeatureVector());
        } else if (RegressionImporter.fieldNames.value != null) {
            pipeList.add(new ValueString2FeatureVector(RegressionImporter.fieldNames.value));
        } else {
            pipeList.add(new ValueString2FeatureVector());
        }
        if (RegressionImporter.integerResponse.value) {
            pipeList.add(new Target2Integer());
        } else {
            pipeList.add(new Target2Double());
        }
        CsvIterator reader = new CsvIterator((Reader)new FileReader(RegressionImporter.inputFile.value), RegressionImporter.lineRegex.value, RegressionImporter.dataOption.value, RegressionImporter.labelOption.value, RegressionImporter.nameOption.value);
        InstanceList instances = new InstanceList(new SerialPipes(pipeList));
        instances.addThruPipe(reader);
        System.out.println(instances.getDataAlphabet());
        instances.save(RegressionImporter.outputFile.value);
    }
}

