% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.pr.points.R
\name{autoplot.pr.points}
\alias{autoplot.pr.points}
\title{Create a basic plot showing locations of downloaded PR points}
\usage{
\method{autoplot}{pr.points}(
  object,
  ...,
  shp_df = NULL,
  admin_level = "admin0",
  map_title = "PR Survey Locations",
  fill_legend_title = "Raw PR",
  fill_scale_transform = "identity",
  facet = NULL,
  hide_confidential = FALSE,
  printed = TRUE
)
}
\arguments{
\item{object}{a pr.points object downloaded using \code{\link{getPR}}}

\item{...}{Other arguments passed to specific methods}

\item{shp_df}{Shapefile(s) (data.frame) to plot with downloaded points. (If not specified automatically uses getShp() for all countries included in pr.points object).}

\item{admin_level}{the administrative level used for plotting administrative boundaries; either \code{"admin0"}; \code{"admin1"} OR \code{"both"}}

\item{map_title}{custom title used for the plot}

\item{fill_legend_title}{Add a title to the legend.}

\item{fill_scale_transform}{String givning a transformation for the fill aesthetic.
See the trans argument in \code{\link[ggplot2]{continuous_scale}} for possible values.}

\item{facet}{if TRUE, splits map into a separate facet for each malaria species; by default FALSE if only one species is present in object, TRUE if both P. falciparum and P. vivax data are present in object.}

\item{hide_confidential}{if TRUE, removes confidential points from the map}

\item{printed}{Should the plot be printed to the graphics device.}
}
\value{
\code{autoplot.pr.points} returns a plots (gg object) for the supplied pr.points dataframe.
}
\description{
\code{autoplot.pr.points} creates a map of PR points downloaded from MAP.
}
\examples{
\dontrun{
PfPR_surveys_NGA <- getPR(country = c("Nigeria"), species = "Pf")
autoplot(PfPR_surveys_NGA)

# Download PfPR2-10 Raster (Bhatt et al. 2015) and raw survey points for Madagascar in
#   2013 and visualise these together on a map.

# Download madagascar shapefile to use for raster download.
MDG_shp <- getShp(ISO = "MDG", admin_level = "admin0")

# Download PfPR2-10 Raster for 2013 & plot this
MDG_PfPR2_10 <- getRaster(surface = "Plasmodium falciparum PR2-10", shp = MDG_shp, year = 2013)
p <- autoplot(MDG_PfPR2_10)

# Download raw PfPR survey points & plot these over the top of the raster
pr <- getPR(country = c("Madagascar"), species = "Pf")
# p[[1]] +
# geom_point(data = pr[pr$year_start==2013,],
#            aes(longitude, latitude, fill = positive / examined,
#                size = examined), shape = 21) +
#   scale_size_continuous(name = "Survey Size") +
#   scale_fill_distiller(name = "PfPR", palette = "RdYlBu") +
#   ggtitle("Raw PfPR Survey points\n + Modelled PfPR 2-10 in Madagascar in 2013")
}

}
