% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intGenes.R
\name{intGenes}
\alias{intGenes}
\title{Select initial gene list from original data matrix.}
\usage{
intGenes(dat, grp, nfolds.out = 2, top.per = 0.05)
}
\arguments{
\item{dat}{Original gene expression data matrix with G rows (number of genes) and S column (number of samples).}

\item{grp}{Class labels.}

\item{nfolds.out}{Outer cross validation number (default is 2).}

\item{top.per}{All genes are ranked based on their models performance and \code{ top.per\%} of them are selected as initial genes.}
}
\value{
Selected initial genes.
}
\description{
Train G-1 SVM models in \code{k-fold} cross validation scheme to select initial genes list.
}
\examples{
data(malanidata)
int <- intGenes(dat,grp)
print(int$top.genes)
}

