% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_canny.R
\name{interactive_canny}
\alias{interactive_canny}
\title{interactive canny edge detection}
\usage{
interactive_canny(
  image,
  range_max_radius = 30,
  range_max_sigma = 2,
  resolution = 0.1,
  return_param = FALSE,
  scale
)
}
\arguments{
\item{image}{a magick image object}

\item{range_max_radius}{define maximum in slider of radius. must be positive.}

\item{range_max_sigma}{define maximum in slider of sigma. must be positive.}

\item{resolution}{resolution of slider}

\item{return_param}{If return_param is TRUE, returns values of radius, sigma, lower\%, and upper\% represented in the format of 'magick'. If return_param is FALSE, returns a magick image object.}

\item{scale}{geometry to be passed to image_scale function of magick package. image is scaled just for preview and result image is not scaled if scale is given.}
}
\value{
a magick image object or values of radius, sigma, lower\%, and upper\% represented in the format of 'magick'
}
\description{
Using image_canny of 'magick' interactively.
radius, sigma, lower\%, and upper\% are parameters of image_canny. See reference manual of 'magick' for detail.
}
\examples{
\donttest{
if (interactive())
{
  interactive_canny(wizard)
}
}
}
\author{
Shota Ochi
}
