% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/illuplot.R
\name{illu.plot}
\alias{illu.plot}
\title{Illustration plot of the procedure t0 detect change points}
\usage{
illu.plot(mu, z, gamma, whichcp, b, Tmax, Tmin)
}
\arguments{
\item{mu}{a vector of piecewise constant}

\item{z}{a vector of stationary Gaussian random error}

\item{gamma}{bandwidth of nonparameter smoothing}

\item{whichcp}{output of the function \code{\link{which.cp}}}

\item{b}{a scalar of location tolerance, specified by user}

\item{Tmax}{a vector of true peak locations}

\item{Tmin}{a vector true valley locations}
}
\value{
a figure plot showing detection of change points
}
\description{
Illustration plot of the procedure t0 detect change points
}
\examples{
set.seed(2019)
L = 1200
A = c(2.8,0,-2.4,0,-3,0.5,3,5,2,0)/1.5
Tmax = c(150,410,680,770,980)
Tmin = c(250,320,550,1000,1100)
H = c(150,250,320,410,550,680,770,980,1000,1100)
mu = GenMu(A,H,L); z = GenZ(nu=2,L)
y1 = GenDY(mu=mu,z=z,gamma=6)
chest = ch.est(nu=2,gamma=6,size=L,B=100)
chp= which.cp(y1,chest,level=0.1)
illu.plot(mu,z,gamma=6,chp,b=5,Tmax,Tmin)
}
