% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openrouter_processor.R
\name{OpenRouterProcessor}
\alias{OpenRouterProcessor}
\title{OpenRouter API Processor}
\description{
OpenRouter API Processor

OpenRouter API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for OpenRouter models.
Handles OpenRouter-specific API calls, authentication, and response parsing.
}
\section{Super class}{
\code{\link[mLLMCelltype:BaseAPIProcessor]{mLLMCelltype::BaseAPIProcessor}} -> \code{OpenRouterProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenRouterProcessor-new}{\code{OpenRouterProcessor$new()}}
\item \href{#method-OpenRouterProcessor-get_default_api_url}{\code{OpenRouterProcessor$get_default_api_url()}}
\item \href{#method-OpenRouterProcessor-make_api_call}{\code{OpenRouterProcessor$make_api_call()}}
\item \href{#method-OpenRouterProcessor-extract_response_content}{\code{OpenRouterProcessor$extract_response_content()}}
\item \href{#method-OpenRouterProcessor-clone}{\code{OpenRouterProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenRouterProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenRouterProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize OpenRouter processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenRouterProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenRouterProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-OpenRouterProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default OpenRouter API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenRouterProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenRouterProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-OpenRouterProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to OpenRouter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenRouterProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenRouterProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-OpenRouterProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from OpenRouter API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenRouterProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenRouterProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OpenRouterProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenRouterProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
