% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimax_processor.R
\name{MinimaxProcessor}
\alias{MinimaxProcessor}
\title{Minimax API Processor}
\description{
Minimax API Processor

Minimax API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for Minimax models.
Handles Minimax-specific API calls, authentication, and response parsing.
}
\section{Super class}{
\code{\link[mLLMCelltype:BaseAPIProcessor]{mLLMCelltype::BaseAPIProcessor}} -> \code{MinimaxProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MinimaxProcessor-new}{\code{MinimaxProcessor$new()}}
\item \href{#method-MinimaxProcessor-get_default_api_url}{\code{MinimaxProcessor$get_default_api_url()}}
\item \href{#method-MinimaxProcessor-make_api_call}{\code{MinimaxProcessor$make_api_call()}}
\item \href{#method-MinimaxProcessor-extract_response_content}{\code{MinimaxProcessor$extract_response_content()}}
\item \href{#method-MinimaxProcessor-clone}{\code{MinimaxProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimaxProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-MinimaxProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize Minimax processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimaxProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimaxProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-MinimaxProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default Minimax API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimaxProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimaxProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-MinimaxProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to Minimax
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimaxProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimaxProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-MinimaxProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from Minimax API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimaxProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimaxProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MinimaxProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimaxProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
