% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xytb-class.R
\name{xytb}
\alias{xytb}
\alias{xytb,missing,missing,ANY,ANY,ANY-method}
\alias{xytb,data.frame,character,ANY,ANY,ANY-method}
\alias{xytb,data.frame,character}
\alias{xytb,data.frame,character,vector,vector,ANY-method}
\alias{xytb,data.frame,character,vector,vector}
\alias{xytb,data.frame,character,vector,vector,vector-method}
\alias{xytb,data.frame,character,vector,vector,vector}
\title{xytb class constructor}
\usage{
xytb(object, desc, winsize, idquant, move, ...)

\S4method{xytb}{missing,missing,ANY,ANY,ANY}(desc = "null xybt object")

\S4method{xytb}{data.frame,character,ANY,ANY,ANY}(object, desc, winsize, idquant, move, ...)

\S4method{xytb}{data.frame,character,vector,vector,ANY}(object, desc, winsize, idquant, move, ...)

\S4method{xytb}{data.frame,character,vector,vector,vector}(
  object,
  desc = "unknow track",
  winsize = seq(3, 13, 2),
  idquant = seq(0, 1, 0.25),
  move = c(5, 10),
  ...
)
}
\arguments{
\item{object}{a data frame with 5 columns
\tabular{ccc}{
id \tab individual id \tab character \cr
x \tab longitude \tab decimal degree \cr
y \tab latitude \tab decimal degree \cr
t \tab date and time \tab POSIXct \cr
b \tab behaviour \tab character \cr
}}

\item{desc}{vector of character describing the dataset}

\item{winsize}{a numerical vector giving the length of the windows used to
calculate moving standard deviation, average, mad and quantile for the speed
(v), the distance (dist) and the relative angle (thetarel).}

\item{idquant}{a numerical vector giving the quantiles to be calculated. For example if
idquant=c(0,0.25,.5,1), the quantiles at 0\% (min), 25\% (first
quartile), 50\% (median) and 100\% (max) will be
calculated.}

\item{move}{a numerical vector providing the shift used to computed parameters
back in time. For example if move=c(5,10,100), the parameters will be shifted
backward by 5, 10 and 100 locations. Optional.}

\item{...}{part of the generic definition}
}
\value{
an xytb object
}
\description{
The methods to build an xytb object (see \link[m2b]{xytb-class} for the class
description).
}
\section{Methods' signature}{

\itemize{
	\item \code{xytb()}: generate an empty xytb object.
	\item \code{xytb(data.frame,character vector)}: generate an xytb object
	with track information (only slot desc, xyt and b are computed).
	\item \code{xytb(data.frame,character vector,numerical vector,
	numerical vector,numerical vector)}: generate an xytb object with track
	information (slots \code{desc}, \code{xyt}, \code{b}) and derived
	information \code{dxyt} and
	\code{befdxyt}. \code{dxyt} contains statistical derivatives of speed, distance and
	relative angle calculated on moving windows given by the winsize
	parameters. Statistical derivatides are standard deviation, mean, median
	absolute deviation and quantiles. Quantiles are defined by the
	\code{idquant}
	parameters. \code{befdxyt} contains \code{dxyt} values shifted back in
	time according to the \code{move} parameters.
}
}

\examples{
#generate an empty xytb object
xytb()
#generate an xytb object with track information only
#track_CAGA_005 is a dataset
simplexytb<-xytb(track_CAGA_005,"a track")
#generate a complete xytb object with derived (over moving windows of 3, 5
#and 9 points, with quantile at 0, 50 and 100\%) and shifted information on 10
#and 100 points
xytb<-xytb(track_CAGA_005,"a track",c(3,5,9),c(0,.5,1),c(10,100))

}
\author{
Laurent Dubroca
}
