% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/luq_streamchem_doc.R
\docType{data}
\name{luq_streamchem}
\alias{luq_streamchem}
\title{LUQ Stream Chemistry Data for Quebrada Sonadora (QS) site}
\format{
A tibble with 597 rows and 18 variables:
\describe{
\item{Sample_ID}{a character denoting Watershed or Collector's location where the sample is taken}
\item{Sample_Date}{a date denoting the date when the sample was collected}
\item{Gage_Ht}{a number denoting the height of the water surface above the gage datum (zero point) at sampling time (in meters)}
\item{Temp}{a number denoting the temperature of the sample collected}
\item{pH}{a number pH (Electrometric with combination electrode)}
\item{Cond}{a number denoting the conductivity (Conductivity bridge in micro siemens/cm)}
\item{Cl}{a number denoting the concentration of Chloride (up to 1989 by automated colorimetric analysis (thiocyanate); after 1989 by liquid chromatography with conductivity detection) in mg Cl/L}
\item{NO3}{a number denoting the concentration of dissolved nitrate in the stream water in ug N/L}
\item{SO4-S}{a number denoting the concentration of Sulfate (Liquid chromatography; conductivity detection) in mg/L}
\item{Na}{a number denoting the concentration of Sodium (up to 1994 by atomic absorption spectroscopy) in mg/L}
\item{K}{a number denoting the concentration of Potassium (up to 1994 by atomic absorption spectroscopy) in mg/L}
\item{Mg}{a number denoting the concentration of Magnesium (up to 1994 by atomic absorption spectroscopy) in mg/L}
\item{Ca}{a number denoting the concentration of Calcium (up to 1994 by atomic absorption spectroscopy) in mg/L}
\item{NH4-N}{a number denoting the concentration of Ammonium Nitrogen (automated colorimetric analysis (phenolhypochlorite)) in ug N/L}
\item{DOC}{a number denoting Dissolved Organic Carbon in the stream water ion milligrams carbon per liter (mg C/L)}
\item{DIC}{a number denoting Dissolved Inorganic Carbon (by syringe stripping and infrared spectroscopy (Stainton 1973)) in mg C/L}
\item{SiO2}{a number denoting the concentration of Silica (automated colorimetric analysis (molybdate blue)) in mg SiO2/L}
\item{TSS}{a number denoting the Total Suspended Sediments in mg/L}
}
}
\source{
{McDowell, W. 2021. Chemistry of stream water from the Luquillo Mountains ver 4923056. Environmental Data Initiative.}
\doi{10.6073/pasta/0a09f5aa2e6f11451553c92b102279a6}
}
\usage{
luq_streamchem
}
\description{
Data include stream chemistry data for the Quebrada Sonadora (QS) location part of the Luqillo LTER site
}
\keyword{datasets}
