% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignOrderedBinom}
\alias{getDesignOrderedBinom}
\title{Power and Sample Size for Cochran-Armitage Trend Test for
Ordered Multi-Sample Binomial Response}
\usage{
getDesignOrderedBinom(
  beta = NA_real_,
  n = NA_real_,
  ngroups = NA_integer_,
  pi = NA_real_,
  w = NA_real_,
  allocationRatioPlanned = NA_integer_,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ngroups}{The number of treatment groups.}

\item{pi}{The response probabilities for the treatment groups.}

\item{w}{The scores assigned to the treatment groups. This should
reflect the ordinal nature of the treatment groups, e.g. dose levels.
Defaults to equally spaced scores.}

\item{allocationRatioPlanned}{Allocation ratio for the treatment groups.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designOrderedBinom} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The maximum number of subjects.
\item \code{ngroups}: The number of treatment groups.
\item \code{pi}: The response probabilities for the treatment groups.
\item \code{w}: The scores assigned to the treatment groups.
\item \code{trendstat}: The Cochran-Armitage trend test statistic.
\item \code{allocationRatioPlanned}: Allocation ratio for the treatment
groups.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for the Cochran-Armitage trend test for ordered
multi-sample binomial response.
}
\details{
An ordered multi-sample binomial response design is used to test
whether the response probabilities differ across multiple treatment
groups. The null hypothesis is that the response probabilities
are equal across all treatment groups, while the alternative
hypothesis is that the response probabilities
are ordered, i.e. the response probability increases with
the treatment group index.
The Cochran-Armitage trend test is used to test this hypothesis.
This test effectively regresses the response probabilities
against treatment group scores, and test whether
the slope of the regression line is significantly different
from zero.

The trend parameter is defined as
\deqn{\theta = \sum_{g=1}^{G} r_g (w_g - \bar{w}) \pi_g}
where \eqn{G} is the number of treatment groups,
\eqn{r_g} is the randomization probability for treatment group
\eqn{g}, \eqn{w_g} is the score assigned to treatment group \eqn{g},
\eqn{\pi_g} is the response probability for
treatment group \eqn{g}, and \eqn{\bar{w} = \sum_{g=1}^{G} r_g w_g} is
the weighted average score across all treatment groups.

Since \eqn{\hat{\theta}} is a linear combination of the estimated
response probabilities, its variance is given by
\deqn{Var(\hat{\theta}) = \frac{1}{n}\sum_{g=1}^{G} r_g
(w_g - \bar{w})^2 \pi_g(1-\pi_g)}
where \eqn{n} is the total sample size.

The sample size is chosen such that the power to reject the null
hypothesis is at least \eqn{1-\beta} for a given
significance level \eqn{\alpha}.
}
\examples{

(design1 <- getDesignOrderedBinom(
  beta = 0.1, ngroups = 3, pi = c(0.1, 0.25, 0.5), alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
