% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{raster_fevd}
\alias{raster_fevd}
\title{Turn Raster of Annual Maximums into Extreme Value Distributions parameters for Netcdf Output}
\usage{
raster_fevd(
  r,
  evd_mod_str,
  nsloc = NULL,
  outfile = NULL,
  cores = 1,
  ntries = 1,
  silent = FALSE,
  seed = NULL
)
}
\arguments{
\item{r}{SpatRaster}

\item{evd_mod_str}{either a string "fgumbel", "fgev" or "fgumbelx" from the extreme value distribution (evd) in the evd package}

\item{nsloc}{A data frame with the same number of rows as the length of x, for linear modelling of the location parameter. The data frame is treated as a covariate matrix (excluding the intercept). A numeric vector can be given as an alternative to a single column data frame.}

\item{outfile}{filename to write to netcdf}

\item{cores}{positive integer. If cores > 1, a 'parallel' package cluster with that many cores is created and used. You can also supply a cluster object. Ignored for functions that are implemented by terra in C++ (see under fun)}

\item{ntries}{The \code{integer} number of tries to fit the evd}

\item{silent}{logical: should the report of error messages be suppressed?}

\item{seed}{set the seed for fitting.}
}
\value{
the parameters of the evd in a SpatRasterDataset
}
\description{
Turn Raster of Annual Maximums into Extreme Value Distributions parameters for Netcdf Output
}
\examples{
require(terra)
r = rast(system.file("extdata/50km_AnnMax_agcd_v1_tmax_mean_r005_daily_1980-2019.nc"
,package = "loopevd"))
r2 = aggregate(r,4) #lower the resolution for a fast example
gumbel_r = raster_fevd(r2,"fgumbel",seed = 1)
plot(gumbel_r$loc,main = "location")
}
\seealso{
\code{\link[evd:fgev]{evd::fgev()}}, \code{\link[evd:fgumbelx]{evd::fgumbelx()}}
}
