% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creg.R
\name{creg}
\alias{creg}
\title{Bayesian multivariate regression with unstructured covariance  matrix for high dimensional longitudinal data.}
\usage{
creg(m, n, chains, n.adapt, data)
}
\arguments{
\item{m}{Starting number of column from where repeated observations begin}

\item{n}{Ending number of columns till where the repeated observations ends}

\item{chains}{Number of MCMC chains to be performed}

\item{n.adapt}{Number of iterations to be performed}

\item{data}{High dimensional longitudinal data}
}
\value{
Results of posterior means and standard deviation.
}
\description{
Multivariate Regression with unstructured covariance  matrix in longitudinal datasetup with high dimensional.
}
\examples{
##
data(repdata)
creg(m=4,n=7,chains=4,n.adapt=100,data=repdata)
##
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2013). Bayesian data analysis. CRC press.

Fitzmaurice, G. M., Laird, N. M., & Ware, J. H. (2012). Applied longitudinal analysis (Vol. 998). John Wiley & Sons.
}
\author{
Atanu Bhattacharjee, Akash Pawar and Bhrigu Kumar Rajbongshi
}
