% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_netlogo_shape.R
\name{get_netlogo_shape}
\alias{get_netlogo_shape}
\title{Download NetLogo shapes from LogoShapes}
\usage{
get_netlogo_shape(
  shape,
  collection = "netlogo-refined",
  dir = tempdir(),
  user_agent = "logolink <https://CRAN.R-project.org/package=logolink>",
  auth_token = Sys.getenv("GH_TOKEN")
)
}
\arguments{
\item{shape}{A \code{\link[base:character]{character}} vector indicating the names
of the shapes to download.}

\item{collection}{(optional) A \code{\link[base:character]{character}} string
indicating the collection of shapes to download from
(default: \code{"netlogo-refined"}).}

\item{dir}{(optional) A \code{\link[base:character]{character}} string indicating
the directory where the shapes will be saved (default: \code{tempdir()}).}

\item{user_agent}{(optional) A \code{\link[base:character]{character}} string
indicating the user agent to use for the
\href{https://docs.github.com/en/rest}{GitHub API}
requests.
(default: \code{"logolink <https://CRAN.R-project.org/package=logolink>"}).}

\item{auth_token}{(optional) A \code{\link[base:character]{character}} string
indicating a GitHub Personal Access Token
(\href{https://en.wikipedia.org/wiki/Personal_access_token}{PAT})
for authentication with the
\href{https://docs.github.com/en/rest}{GitHub API}.
This is useful when dealing with rate limits.
(default: \code{Sys.getenv("GH_TOKEN")}).}
}
\value{
A named \code{\link[base:character]{character}} vector with the file paths
to the downloaded NetLogo shapes as
\href{https://en.wikipedia.org/wiki/SVG}{SVG} files.
}
\description{
\code{get_netlogo_shape()} downloads NetLogo shapes from the
\href{https://github.com/danielvartan/logoshapes}{LogoShapes} project on
\href{https://github.com/}{GitHub}.

The collections and shapes available for download can be found in the
\href{https://github.com/danielvartan/logoshapes}{LogoShapes} project
\href{https://github.com/danielvartan/logoshapes/tree/main/svg}{\code{svg}}
directory. Refer to the
\href{https://github.com/danielvartan/logoshapes}{LogoShapes} documentation for
more information about the different collections.

\strong{Note}: This function requires an active internet connection and the
\href{https://httr2.r-lib.org/}{\code{httr2}} package.
}
\examples{
\dontrun{
  library(fs)
  library(magick)
}

\dontrun{
  shape <- get_netlogo_shape("turtle")

  file_size(shape)

  shape |> image_read_svg() |> image_ggplot()
}

\dontrun{
  shape <- get_netlogo_shape("turtle", collection = "netlogo-simplified")

  file_size(shape)

  shape |> image_read_svg() |> image_ggplot()
}

\dontrun{
  shape <- get_netlogo_shape("turtle", collection = "netlogo-7-0-3")

  file_size(shape)

  shape |> image_read_svg() |> image_ggplot()
}
}
\concept{utility functions}
