% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{transform_data}
\alias{transform_data}
\title{Transform a data.frame according to the requirements of the model}
\usage{
transform_data(
  data,
  reference_year,
  usual_weekly_hours,
  female_spec = "F",
  male_spec = "M",
  age_spec = NULL,
  entry_date_spec = NULL
)
}
\arguments{
\item{data}{a dataframe object as produced by \code{read_data} which is to
be transformed}

\item{reference_year}{a number indicating the reference year of the analysis}

\item{usual_weekly_hours}{an optional numeric representing the usual weekly
working hours}

\item{female_spec}{a string or number indicating the way females are
specified in the dataset.}

\item{male_spec}{a string or number indicating the way males are
specified in the dataset}

\item{age_spec}{a string indicating the age specification, can be one of
\code{NULL}, \code{"age"}, \code{"birthyear"}, or \code{"date_of_birth"}. If
this parameter is set to \code{NULL}, the function automatically tries to
infers the specification}

\item{entry_date_spec}{a string indicating the entry_date specification, can
be one of \code{NULL}, \code{"years"}, \code{"entry_year"}, or
\code{"entry_date"}. If this parameter is set to \code{NULL}, the function
automatically tries to infers the specification}
}
\description{
Transforms specific columns of a data.frame to match the requirements of
the standard analysis model.
}
