% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupSurvey.R
\name{setupSurvey}
\alias{setupSurvey}
\title{Set up a new "survey" with a standardized structure recognized by the package.}
\usage{
setupSurvey(
  folder,
  projectName,
  run = 1,
  coordinatesFile,
  siteWavsFolder,
  adjustmentsFile,
  channelsFile,
  date,
  time,
  tempC = 15,
  soundSpeed,
  surveyLength,
  margin = 10,
  zMin = -1,
  zMax = 20,
  resolution = 1,
  buffer = 0.2
)
}
\arguments{
\item{folder}{Character. Path to the directory where the survey will be created.}

\item{projectName, run, coordinatesFile, siteWavsFolder}{Arguments passed to
\code{\link{createSettings}}}

\item{adjustmentsFile}{Character. File path to the adjustments file (csv).
Optional argument.}

\item{channelsFile}{Character. File path to the adjustments file (csv). If missing,
an empty channels file (csv) will be created.}

\item{date}{Numeric. Eight digit number representing a date in the format
YYYYMMDD.}

\item{time}{Numeric. Five or six digit number representing the start time
of a recording session (90000 = 09:00:00, and 160000 = 16:00:00).}

\item{tempC}{Numeric. Temperature in degrees C, which is used to calculate
the speed of sound in air using the equation 331.45*sqrt(1+tempC/273.15).}

\item{soundSpeed}{Numeric. The speed of sound in meters per second. If missing,
the speed of sound is calculated based on the specified
temperature (assuming the transmission medium is air). If soundSpeed is
specified, the tempC value is over-ridden.}

\item{surveyLength, margin, zMin, zMax, resolution, buffer}{Arguments describing the area to be searched
for sound sources. Passed to \code{\link{createSettings}}.}
}
\value{
data.frame containing the settings generated using \code{\link{createSettings}}.
    This data.frame is identical to that produced by reading the settingsFile csv, which
    is also written to file.
}
\description{
\code{setupSurvey} sets up the folder structure for a new "survey", which
corresponds to a single recording session. By setting up
a standardized folder structure, the package functions can carry out much of the
data wrangling automatically using the \code{localizeSingle} and \code{localizeMultiple}
functions. The extra work required to set up surveys in a standard format can
save time later on.
}
\examples{
    survey <- setupSurvey(folder = tempdir(), projectName = 'Ex', run = 1,
        coordinatesFile = system.file('extdata', 'Vignette_Coordinates.csv', package = 'locaR'),
        siteWavsFolder = tempdir(),
        date = '20200617', time = '090000', surveyLength = 7)
}
