% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmtp_control.R
\name{lmtp_control}
\alias{lmtp_control}
\title{Set LMTP Estimation Parameters}
\usage{
lmtp_control(
  .bound = 1e+05,
  .trim = 0.999,
  .learners_outcome_folds = 10,
  .learners_trt_folds = 10,
  .return_full_fits = FALSE,
  .discrete = TRUE,
  .info = FALSE
)
}
\arguments{
\item{.bound}{[\code{numeric(1)}]\cr
Determines that maximum and minimum values (scaled) predictions
will be bounded by. The default is 1e-5, bounding predictions by 1e-5 and 0.9999.}

\item{.trim}{[\code{numeric(1)}]\cr
Determines the amount the density ratios should be trimmed.
The default is 0.999, trimming the density ratios greater than the 0.999 percentile
to the 0.999 percentile. A value of 1 indicates no trimming.}

\item{.learners_outcome_folds}{[\code{integer(1)}]\cr
The number of cross-validation folds for \code{learners_outcome}.}

\item{.learners_trt_folds}{[\code{integer(1)}]\cr
The number of cross-validation folds for \code{learners_trt}.}

\item{.return_full_fits}{[\code{logical(1)}]\cr
Return full 'SuperLearner' fits? Default is \code{FALSE}, return only 'SuperLearner' coefficients.}

\item{.discrete}{[\code{logical(1)}]\cr
Use discrete or ensemble super learner?}

\item{.info}{[\code{logical(1)}]\cr
Print super learner fitting info to the console?}
}
\value{
A list of parameters controlling the estimation procedure.
}
\description{
Set LMTP Estimation Parameters
}
\examples{
lmtp_control(.trim = 0.975)
}
