% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmerp.R
\name{lmerp}
\alias{lmerp}
\title{This function is used for permutation test for general and mixed linear regression}
\usage{
lmerp(formula, data, thresh, R, mixed, minimum)
}
\arguments{
\item{formula}{Regression formula in the form 'y~x1+x2+x3' for general linear function or
'y~x1+x2+x3+(1|x4)' or 'y~x1+x2+x3+(x3|x4)' for mixed linear function}

\item{data}{A data frame specifying the data to be analysed}

\item{thresh}{Threshold to stop iteration, default value is 0.1}

\item{R}{The maximum number of iteration, default value is 1000}

\item{mixed}{A logic value indicates if you desire to perform mixed linear  model or not.
Default value is FALSE.}

\item{minimum}{The minimum number of iteration, default value is 50}
}
\value{
A list contains 2 items: Results and T_perm, the former contains results of origi
-nal parameter test and results of permutation test including adjusted confident interval
(Ci_perm), p values (P_perm), iteration number(Iteration), the later contains a list cont
-ains all t values generated in each permutation
}
\description{
perform general and mixed linear regression by lm function in R base or lmer
function in lmer/lmertest package and permutation tests on observed t values of beta coef
-ficients
}
\examples{
formula<-mpg~cyl
data<-mtcars
my_perm<-lmerp(formula,data)
}
