% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_code.R
\name{extract_bash_code}
\alias{extract_bash_code}
\title{Extract Bash/Shell code from a string}
\usage{
extract_bash_code(input_string)
}
\arguments{
\item{input_string}{A string containing Bash/Shell code blocks, typically a response
from an LLM}
}
\value{
A character vector containing the extracted Bash/Shell code
}
\description{
This function extracts Bash/Shell code from a string by matching all content between
'```bash', '```sh', '```shell' and '```'.
}
\examples{
# Simple bash example
text <- "Run this:\n```bash\necho 'Hello'\n```"
extract_bash_code(text)

# Using 'sh' tag
text <- "```sh\nls -la\npwd\n```"
extract_bash_code(text)

# Using 'shell' tag
text <- "```shell\nfor i in {1..5}; do echo $i; done\n```"
extract_bash_code(text)

# Multiple blocks with different tags
response <- "
Setup script:
```bash
#!/bin/bash
mkdir -p /tmp/test
cd /tmp/test
```

Installation:
```sh
apt-get update
apt-get install -y git
```

Configuration:
```shell
export PATH=$PATH:/usr/local/bin
source ~/.bashrc
```
"
codes <- extract_bash_code(response)
length(codes) # Returns 3

# Complex script example
script_response <- "
Here's a backup script:
```bash
#!/bin/bash

# Set variables
BACKUP_DIR='/backup'
DATE=$(date +\%Y\%m\%d)

# Create backup
tar -czf ${BACKUP_DIR}/backup_${DATE}.tar.gz /home/user/

# Check if successful
if [ $? -eq 0 ]; then
    echo 'Backup completed successfully'
else
    echo 'Backup failed'
    exit 1
fi
```
"
extract_bash_code(script_response)

}
