% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linpk.R
\name{generateETA}
\alias{generateETA}
\title{Generate individual random effects from a multivariate normal distribution.}
\usage{
generateETA(n, omegaLT, omega = LTmat(omegaLT), eta.names = colnames(omega))
}
\arguments{
\item{n}{The number of individuals.}

\item{omegaLT}{A numeric vector giving the elements of the lower triangle
of the covariance matrix by row.}

\item{omega}{The covariance matrix.}

\item{eta.names}{A character vector of names for each random effect
(defaults to the column names of \code{omega}, or if \code{NULL} then to
ETA1, ETA2, ...).}
}
\value{
An \eqn{n \times p} matrix, where each row contains the vector of random
effects for one individual (\eqn{p} is the size of the covariance matrix).
}
\description{
Generate individual random effects from a multivariate normal distribution.
}
\examples{
omegaLT <- c(0.123, 0.045, 0.678)
generateETA(10, omegaLT)
}
\seealso{
\code{\link{LTmat}}
\code{\link{blockdiag}}
}
