% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{pipes}
\alias{pipes}
\alias{\%child\%}
\alias{\%or\%}
\alias{\%with\%}
\title{Infixes}
\usage{
lhs \%child\% rhs

lhs \%or\% rhs

lhs \%with\% rhs
}
\arguments{
\item{lhs, rhs}{Selectors as returned by \verb{sel_*} family of functions.}
}
\description{
Convenient pipes for more sophisticated selectors.
}
\section{Operators}{

\itemize{
\item \code{\link{\%child\%}} - Selects elements where right hand is child of left hand, e.g.: \code{sel_tag('div') \%child\% sel_class('aClass')} selects elements with \code{aClass} who are direct children of \code{div} tags.
\item \code{\link{\%or\%}} - Select left hand or right hand, e.g.: \code{sel_id('myId') \%or\% sel_class('myClass')} will select both the element with the id and elements with the class. Ideal to select and apply rules multiple elements at once.
\item \code{\link{\%with\%}} - Left hand selector with right hand selector, e.g.: \code{sel_tag('div') \%with\% sel_class('aClass')} selects a \code{div} with a class of \code{aClass}. Ideal to narrow down the selection.
}
}

\examples{
# select all paragraph 'p' with "red" class
sel_tag("p") \%with\% sel_class("red")

# the other way around works equally well
sel_class("red") \%with\% sel_tag("p")

# select multiple elements
# where id = "x" or class = "center" 
sel_id("x") \%or\% sel_class("center")

# select element with id = "x" and parent's id = "y"
sel_id("y") \%child\% sel_id("y")

}
