% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{register_leaflet}
\alias{register_leaflet}
\title{Register a Leaflet Component}
\usage{
register_leaflet(
  session,
  registry,
  leaflet_output_id,
  data_reactive,
  shared_id_column,
  lng_col = "longitude",
  lat_col = "latitude",
  highlight_zoom = 12,
  click_handler = NULL
)
}
\arguments{
\item{session}{'shiny' session object. The session from the module where the DT is used. This could be global session in non-modular apps.}

\item{registry}{A link registry created by \code{\link[=create_link_registry]{create_link_registry()}}}

\item{leaflet_output_id}{Character string: the outputId of your leafletOutput}

\item{data_reactive}{Reactive expression returning the data frame for the map}

\item{shared_id_column}{Character string: name of the ID column}

\item{lng_col}{Character string: name of longitude column (default: "longitude")}

\item{lat_col}{Character string: name of latitude column (default: "latitude")}

\item{highlight_zoom}{Numeric: zoom level when highlighting (default: 12)}

\item{click_handler}{Optional function: custom click handler for row selection, must have args (map_proxy, selected_data, session), overrides all default behavior}
}
\value{
No return value, called for side effects.
}
\description{
\code{register_leaflet} registers a Leaflet map for linking with other components.
}
\examples{
\donttest{
  # Create a mock session for the example
  session <- shiny::MockShinySession$new()

  # Create a registry
  registry <- create_link_registry(session)

  # Sample reactive data
  my_data <- shiny::reactive({
    data.frame(
      id = 1:5,
      name = c("A", "B", "C", "D", "E"),
      longitude = -111.9 + runif(5, -0.1, 0.1),
      latitude = 40.7 + runif(5, -0.1, 0.1)
    )
  })

  # Register a leaflet component
  register_leaflet(session, registry, "my_map", my_data, "id")

  # Verify registration
  print(registry$get_components())
}
}
