% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example-exponential.R
\name{exponential_lifetime}
\alias{exponential_lifetime}
\title{Exponential lifetime model with right-censoring support}
\usage{
exponential_lifetime(ob_col, censor_col = NULL)
}
\arguments{
\item{ob_col}{The name of the column containing observation times.}

\item{censor_col}{Optional column name indicating censoring status.
When provided, values should be \code{"exact"} for uncensored observations
and \code{"right"} for right-censored observations. When \code{NULL}, all
observations are treated as exact.}
}
\value{
An \code{exponential_lifetime} likelihood model object
}
\description{
A likelihood model for the Exponential(lambda) distribution with
optional right-censoring. This is a reference implementation
demonstrating:
\itemize{
\item \strong{Closed-form MLE}: Overrides \code{fit()} to compute lambda_hat = d/T
directly, bypassing \code{optim} entirely.
\item \strong{Analytical derivatives}: score, Hessian, and FIM in closed form.
\item \strong{Right-censoring}: Natural handling via the sufficient statistic
(d, T) where d = number of exact observations and T = total time.
\item \strong{\code{rdata()} method}: For Monte Carlo validation and FIM estimation.
}

The log-likelihood is:
\deqn{\ell(\lambda) = d \log \lambda - \lambda T}
where d is the number of exact (uncensored) observations and T is the
total observation time (sum of all times, whether censored or not).
}
\examples{
# Uncensored exponential data
model <- exponential_lifetime("t")
df <- data.frame(t = rexp(100, rate = 2))
mle <- fit(model)(df)
coef(mle)  # should be close to 2

# Right-censored data
model_c <- exponential_lifetime("t", censor_col = "status")
df_c <- data.frame(
  t = c(rexp(80, 2), rep(0.5, 20)),
  status = c(rep("exact", 80), rep("right", 20))
)
mle_c <- fit(model_c)(df_c)
coef(mle_c)
}
