% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfc_basics.R
\name{dlfc}
\alias{dlfc}
\alias{plfc}
\alias{qlfc}
\alias{rlfc}
\title{The log2 fold change distribution}
\usage{
dlfc(x, a, b, log = FALSE)

plfc(q, a, b, lower.tail = TRUE, log.p = FALSE)

qlfc(p, a, b, lower.tail = TRUE, log.p = FALSE)

rlfc(n, a, b)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{a}{non-negative parameter}

\item{b}{non-negative parameter}

\item{log, log.p}{if TRUE, probabilities p are given as log(p)}

\item{lower.tail}{if TRUE (default), probabilities are P[X <= x],
otherwise, P[X > x].}

\item{p}{vector of probabilities}

\item{n}{number of observations}
}
\value{
The density
}
\description{
Density, distribution function, quantile function and random
generation for the log2 fold change  distribution with parameters
‘a’ and ‘b’ (corresponding to (pseudo-)counts incremented by 1).
}
\section{Functions}{
\itemize{
\item \code{dlfc()}: Density function

\item \code{plfc()}: Distribution function

\item \code{qlfc()}: Quantile function

\item \code{rlfc()}: random generation

}}
\examples{
x <- seq (-5,5,by=0.01)
plot(x,dlfc(x,1,1))
}
\concept{Log2 fold change distribution}
