% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{k_fold_cv}
\alias{k_fold_cv}
\title{k-Fold Cross Validation}
\usage{
k_fold_cv(
  data = NULL,
  model = NULL,
  random_state = NULL,
  k = 5,
  y_index = ncol(data)
)
}
\arguments{
\item{data}{The dataset to be used}

\item{model}{A classification or a regression model (from LESS package)}

\item{random_state}{A seed number to get reproducable result}

\item{k}{Number of splits on the training set (defaults to 5)}

\item{y_index}{Column index of the response variable on the given \strong{data}. Default is the last column.}
}
\value{
A vector consists of metric of the individual folds and the average metric over the folds
}
\description{
Applies k-Fold cross validation to the given model on the given data
}
\examples{
k_fold_cv(data = iris, model = KNeighborsClassifier$new(), k = 3)
}
