% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifiers.R
\name{SVC}
\alias{SVC}
\title{Support Vector Classification}
\value{
R6 Class of SVC
}
\description{
Wrapper R6 Class of e1071::svm function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `SVC$new`
## ------------------------------------------------

svc <- SVC$new()
svc <- SVC$new(kernel = "polynomial")

## ------------------------------------------------
## Method `SVC$fit`
## ------------------------------------------------

data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

svc <- SVC$new()
svc$fit(X_train, y_train)

## ------------------------------------------------
## Method `SVC$predict`
## ------------------------------------------------

svc <- SVC$new()
svc$fit(X_train, y_train)
preds <- svc$predict(X_test)

svc <- SVC$new()
preds <- svc$fit(X_train, y_train)$predict(X_test)

preds <- SVC$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=preds, reference = factor(y_test)))

## ------------------------------------------------
## Method `SVC$get_estimator_type`
## ------------------------------------------------

svc$get_estimator_type()
}
\seealso{
\code{\link[e1071:svm]{e1071::svm()}}
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{SVC}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SVC-new}{\code{SVC$new()}}
\item \href{#method-SVC-fit}{\code{SVC$fit()}}
\item \href{#method-SVC-predict}{\code{SVC$predict()}}
\item \href{#method-SVC-get_estimator_type}{\code{SVC$get_estimator_type()}}
\item \href{#method-SVC-clone}{\code{SVC$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_isFitted"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_isFitted'><code>less::SklearnEstimator$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVC-new"></a>}}
\if{latex}{\out{\hypertarget{method-SVC-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of SVC
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVC$new(
  scale = TRUE,
  kernel = "radial",
  degree = 3,
  gamma = NULL,
  coef0 = 0,
  cost = 1,
  cache_size = 40,
  tolerance = 0.001,
  epsilon = 0.1,
  shrinking = TRUE,
  cross = 0,
  probability = FALSE,
  fitted = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{A logical vector indicating the variables to be scaled. If scale is of length 1, the value is recycled as many times as needed.
Per default, data are scaled internally (both x and y variables) to zero mean and unit variance.
The center and scale values are returned and used for later predictions (default: TRUE)}

\item{\code{kernel}}{The kernel used in training and predicting. Possible values are: "linear", "polynomial", "radial", "sigmoid" (default is "radial")}

\item{\code{degree}}{Parameter needed for kernel of type polynomial (default: 3)}

\item{\code{gamma}}{Parameter needed for all kernels except linear (default: 1/(data dimension))}

\item{\code{coef0}}{Parameter needed for kernels of type polynomial and sigmoid (default: 0)}

\item{\code{cost}}{Cost of constraints violation (default: 1)—it is the ‘C’-constant of the regularization term in the Lagrange formulation (default: 1)}

\item{\code{cache_size}}{Cache memory in MB (default: 40)}

\item{\code{tolerance}}{Tolerance of termination criterion (default: 0.001)}

\item{\code{epsilon}}{Epsilon in the insensitive-loss function (default: 0.1)}

\item{\code{shrinking}}{Option whether to use the shrinking-heuristics (default: TRUE)}

\item{\code{cross}}{If a integer value k>0 is specified, a k-fold cross validation on the training data is performed to assess the quality of the model:
the accuracy rate for classification and the Mean Squared Error for regression (default: 0)}

\item{\code{probability}}{Logical indicating whether the model should allow for probability predictions (default: FALSE)}

\item{\code{fitted}}{Logical indicating whether the fitted values should be computed and included in the model or not (default: TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{svc <- SVC$new()
svc <- SVC$new(kernel = "polynomial")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVC-fit"></a>}}
\if{latex}{\out{\hypertarget{method-SVC-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the SVM model from the training set (X, y).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVC$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes labels}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of SVC
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

svc <- SVC$new()
svc$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVC-predict"></a>}}
\if{latex}{\out{\hypertarget{method-SVC-predict}{}}}
\subsection{Method \code{predict()}}{
Predict regression value for X0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVC$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Factor of the predict classes.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{svc <- SVC$new()
svc$fit(X_train, y_train)
preds <- svc$predict(X_test)

svc <- SVC$new()
preds <- svc$fit(X_train, y_train)$predict(X_test)

preds <- SVC$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=preds, reference = factor(y_test)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVC-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-SVC-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVC$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{svc$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SVC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
