% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc_brms.R
\name{ppc_brms}
\alias{ppc_brms}
\title{Fitted versus observed plot for brmsfit Objects}
\usage{
ppc_brms(
  object,
  xtitle = "Observed value",
  ytitle = "Fitted value",
  dy = c(0.1, 0.1),
  dx = c(0.1, 0.1),
  cor = FALSE,
  equation = FALSE,
  xcor = NULL,
  ycor = NULL,
  xequ = NULL,
  yequ = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \strong{brmsfit}}

\item{xtitle}{The text for the x-axis title}

\item{ytitle}{The text for the y-axis title}

\item{dy}{Distance from plot to y-axis}

\item{dx}{Distance from plot to x-axis}

\item{cor}{If TRUE, add correlation coefficients with p-values and R}

\item{equation}{If TRUE, add regression line equation}

\item{xcor, ycor}{\code{numeric} Coordinates (in data units) to be used for
absolute positioning of the correlation coefficients}

\item{xequ, yequ}{\code{numeric} Coordinates (in data units) to be used for
absolute positioning of the regression line equation}

\item{...}{Passed to \code{\link[=lehuynh_theme]{lehuynh_theme()}}}
}
\value{
A ggplot object
}
\description{
Plot fitted versus observed values, including confidence interval
(gray area) around best fit line (linear regression line) and
prediction interval (dashed line).
}
\examples{
\dontrun{

library(brms)

mod <- brm(count ~ zAge + zBase * Trt + (1|patient) + (1|obs),
           data = epilepsy,
           family = poisson())

ppc_brms(mod)
ppc_brms(mod, dy = c(0.02, 0.1), dx = c(0.005, 0.1))
ppc_brms(mod, cor = TRUE, equation = TRUE, yequ = 100)
}
}
